CREATE OR REPLACE FUNCTION transaction_insert_policy2(p_schema IN VARCHAR2,
                                                      p_object IN VARCHAR2) RETURN VARCHAR2 IS
  l_predicate VARCHAR2(4000) := NULL;
BEGIN
  IF sys_context('userenv', 'session_user') = 'BANK_IS2' THEN
    RETURN NULL;
  END IF;

  l_predicate := 'account_from = sys_context(''bank_context2'', ''account_no'') AND status=''NEW'' ';

  IF sys_context('bank_context2', 'user_type') = 'TELLER' THEN
    RETURN l_predicate || ' AND trans_type = ''TELLER_PAY''';
  ELSIF sys_context('bank_context2', 'user_type') = 'CLIENT' THEN
    RETURN l_predicate || ' AND trans_type = ''EBANK_PAY''';
  ELSIF sys_context('bank_context2', 'user_type') = 'TERMINAL' THEN
    RETURN l_predicate || ' AND (trans_type = ''CARD_ATM'' OR trans_type = ''CARD_PAY'')';
  END IF;
END transaction_insert_policy2;
/

